package com.swvoyages.reservation;

/*
* L'interface <code>ReservationLookup</code> dfinit la manire 
* de rechercher un partenaire durant le processus de rservation.
*
* @version  1.0
*/
public interface ReservationLookup {

	/*
	* Renvoie le tableau des coordonnes de rservation du
	* partenaire trouv. Celui-ci doit implmenter le service
	* type dont le nom est pass en paramtre et ses coordonnes
	* sont recherches dans le registre UDDI dont l'URL de l'API 
	* de recherche est communique.
	*
	* @param		inquireURL URL de l'API de recherche du
	*				registre UDDI slectionn
	* @param		tModelName nom du service type dont une
	*				implmentation est recherche
	*
	* @return		String[0] URL du fichier WSDL de description
	*				du service type implment
	* 				String[1] URL du point d'accs au service du
	*				partenaire
	*
	* @throws		ReservationException lance si une anomalie se
	*				produit durant la recherche d'un partenaire
	*/
	public String[] lookup(String inquireURL, String tModelName) 
		throws ReservationException;
}